<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_about',
        'title' => esc_html__('PXL About', 'adsett' ),
        'icon' => 'eicon-post-content',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'adsett' ),
                    'tab'      => 'layout',
                    'controls' => array(
                        array(
                            'name'    => 'layout',
                            'label'   => esc_html__( 'Templates', 'adsett' ),
                            'type'    => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__( 'Layout 1', 'adsett' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/imgs/pxl_about-1.jpg'
                                ],
                                 
                            ],
                            'prefix_class' => 'pxl-about-layout-'
                        ),
                    )
                ),
                array(
                    'name'     => 'content_section',
                    'label'    => esc_html__( 'Setting', 'adsett' ),
                    'tab'      => 'content',
                    'controls' => array(
                        array(
                            'name'     => 'sub-title',
                            'label'    => esc_html__('Sub Title', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'Since 2013'
                        ),
                        array(
                            'name'     => 'title',
                            'label'    => esc_html__('Title', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'Architecture, construction services'
                        ),
                        array(
                            'name'     => 'desc',
                            'label'    => esc_html__('Description', 'adsett'),
                            'type'     => 'textarea',
                            'label_block' => true,
                            'default'  => ''
                        ),
                        array(
                            'name'     => 'link_title',
                            'label'    => esc_html__('Link Title', 'adsett'),
                            'type'     => 'text',
                            'label_block' => true,
                            'default'  => 'Get Started'
                        ), 
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'adsett' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
                            'default' => [
                                'url' => '#',
                            ]
                        ),
                    )
                ),
                array(
                    'name' => 'style_section',
                    'label' => esc_html__( 'Style', 'adsett' ),
                    'tab' => 'style',
                    'controls' => array(
                        array(
                            'name' => 'content_bg',
                            'label' => esc_html__('Background', 'adsett' ),
                            'type' =>  'color',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-about-wg' => 'background-color: {{VALUE}};',
                            ],
                        ), 
                        array(
                            'name' => 'sub_title_color',
                            'label' => esc_html__( 'Sub title Color', 'adsett' ),
                            'type' => 'color',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .sub-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__( 'Title Color', 'adsett' ),
                            'type' => 'color',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .title' => 'color: {{VALUE}};'
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'label' => esc_html__( 'Title Typography', 'adsett' ),
                            'selector' => '{{WRAPPER}} .title',
                            'control_type' => 'group',
                        ),
                        array(
                            'name'  => 'title_max_width',
                            'label' => esc_html__( 'Title Max Width (px)', 'adsett' ),
                            'type'  => 'slider',
                            'control_type' => 'responsive',
                            'range' => [
                                'px' => [
                                    'min' => 100,
                                    'max' => 500,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-about-wg .title' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'border_left_color',
                            'label' => esc_html__('Title Border color', 'adsett'),
                            'type' => 'color',
                            'selectors' => [
                                '{{WRAPPER}} .title:before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'desc_color',
                            'label' => esc_html__( 'Description Color', 'adsett' ),
                            'type' => 'color',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'link_color',
                            'label' => esc_html__( 'Link Color', 'adsett' ),
                            'type' => 'color',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .ab-link' => 'color: {{VALUE}};'
                            ],
                        ),
                        array(
                            'name' => 'link_color_hover',
                            'label' => esc_html__( 'Link Color Hover', 'adsett' ),
                            'type' => 'color',
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .ab-link:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),  
            ),
        ),
    ),
    adsett_get_class_widget_path()
);