<?php 
use Elementor\Controls_Manager;
use Elementor\Embed;
use Elementor\Group_Control_Image_Size;

add_action( 'wp_ajax_adsett_get_pagination_html', 'adsett_get_pagination_html' );
add_action( 'wp_ajax_nopriv_adsett_get_pagination_html', 'adsett_get_pagination_html' );
function adsett_get_pagination_html(){
    try{
        if(!isset($_POST['query_vars'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'adsett'));
        }
        $query_vars = isset($_POST['query_vars']) ? $_POST['query_vars'] : null;
        $query = new WP_Query($query_vars);
        ob_start();
        adsett()->page->get_pagination( $query,  true );
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'adsett'),
                'data' => array(
                    'html' => $html,
                    'query_vars' => $query_vars,
                    'post' => $query->have_posts()
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_adsett_get_filter_html', 'adsett_get_filter_html' );
add_action( 'wp_ajax_nopriv_adsett_get_filter_html', 'adsett_get_filter_html' );
function adsett_get_filter_html(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'adsett'));
        }
        $settings = isset($_POST['settings']) ? $_POST['settings'] : null;
        $loadmore_filter = sanitize_text_field($_POST['loadmore_filter']);
        if($loadmore_filter == '1'){
            set_query_var('paged', 1);
            $limit = isset($settings['limit'])?$settings['limit']:'6';
            $limitx = (int)$limit * (int)$settings['paged'];
        }else{
            set_query_var('paged', $settings['paged']);
            $limitx = isset($settings['limit'])?$settings['limit']:'6';
        }
        extract(pxl_get_posts_of_grid($settings['post_type'], [
                'source' => isset($settings['source'])?$settings['source']:'',
                'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
                'order' => isset($settings['order'])?$settings['order']:'desc',
                'limit' => $limitx,
                'post_ids' => isset($settings['post_ids'])?$settings['post_ids']: [],
                'post_not_in' => isset($settings['post_not_in'])?$settings['post_not_in']: [],
            ],
            $settings['tax']
        ));
        $settings['filter_default_title'] = !empty($settings['filter_default_title']) ? $settings['filter_default_title'] : esc_html__( 'All', 'adsett' );
        ob_start();
         
        ?>
            <span class="filter-item active" data-filter="*">
                <?php if($settings['show_cat_count'] == '1'): ?>
                    <span><?php echo count($posts); ?></span> 
                <?php endif; ?>
                <?php echo esc_html($settings['filter_default_title']) ?>
            </span>
            <?php foreach ($categories as $category): ?>
                <?php $category_arr = explode('|', $category); ?>
                <?php $term = get_term_by('slug',$category_arr[0], $category_arr[1]); ?> 
                <?php 
                $num = 0;
                foreach ($posts as $key => $post){
                    $this_terms = get_the_terms( $post->ID, $settings['tax'][0] );
                    $term_list = [];
                    foreach ($this_terms as $t) {
                        $term_list[] = $t->slug;
                    } 
                    if(in_array($term->slug,$term_list))
                        $num++;
                }
                if($num > 0):
                ?>
                <span class="filter-item" data-filter="<?php echo esc_attr('.' . $term->slug); ?>">  
                    <?php if($settings['show_cat_count'] == '1'): ?> 
                    <span><?php echo esc_html($num); ?></span> 
                    <?php endif; ?>
                    <?php echo esc_html($term->name); ?>
                </span>
                <?php endif; ?>
            <?php endforeach; ?>
        <?php 
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'adsett'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}
add_action( 'wp_ajax_adsett_load_more_product_grid', 'adsett_load_more_product_grid' );
add_action( 'wp_ajax_nopriv_adsett_load_more_product_grid', 'adsett_load_more_product_grid' );
function adsett_load_more_product_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'adsett'));
        }
        $settings = isset($_POST['settings']) ? $_POST['settings'] : null;
        set_query_var('paged', $settings['paged']);
        $query_type         = isset($settings['query_type']) ? $settings['query_type'] : 'recent_product';
        $post_per_page      = isset($settings['limit']) ? $settings['limit'] : 8;
        $product_ids        = isset($settings['product_ids']) ? $settings['product_ids'] : '';
        $categories         = isset($settings['categories']) ? $settings['categories'] : '';
        $param_args         = isset($settings['param_args']) ? $settings['param_args'] : [];

        $col_xxl = isset($settings['col_xxl']) ? 'col-xxl-'.str_replace('.', '',12 / floatval($settings['col_xxl'])) : '';
        $col_xl = isset($settings['col_xl']) ? 'col-xl-'.str_replace('.', '',12 / floatval( $settings['col_xl'])) : '';
        $col_lg = isset($settings['col_lg']) ? 'col-lg-'.str_replace('.', '',12 / floatval( $settings['col_lg'])) : '';
        $col_md = isset($settings['col_md']) ? 'col-md-'.str_replace('.', '',12 / floatval( $settings['col_md'])) : '';
        $col_sm = isset($settings['col_sm']) ? 'col-sm-'.str_replace('.', '',12 / floatval( $settings['col_sm'])) : ''; 
        $col_xs = isset($settings['col_xs']) ? 'col-'.str_replace('.', '',12 / floatval( $settings['col_xs'])) : ''; 
 
        $item_class = trim(implode(' ', ['grid-item', $col_xxl, $col_xl, $col_lg, $col_md, $col_sm, $col_xs]));
          
        $loop = adsett_woocommerce_query($query_type,$post_per_page,$product_ids,$categories,$param_args);
        extract($loop);
        
        $data_animation = []; 
        $animate_cls = '';
        $data_settings = '';
        if ( !empty( $settings['item_animation'] ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$settings['item_animation_duration'];
            $data_animation['animation'] = $settings['item_animation'];
            $data_animation['animation_delay'] = $settings['item_animation_delay'];
        }
        if($posts->have_posts()){
            ob_start();
                $d = 0;
                while ($posts->have_posts()) {
                    $posts->the_post();
                    global $product;
                    $d++;
                    $term_list = array();
                    $term_of_post = wp_get_post_terms($product->get_ID(), 'product_cat');
                    foreach ($term_of_post as $term) {
                        $term_list[] = $term->slug;
                    }
                    $filter_class = implode(' ', $term_list);

                    if ( !empty( $data_animation ) ) { 
                        $data_animation['animation_delay'] = ((float)$settings['item_animation_delay'] * $d);
                        $data_animations = json_encode($data_animation);
                        $data_settings = 'data-settings="'.esc_attr($data_animations).'"';
                    }
                     
                    ?>
                    <div class="<?php echo trim(implode(' ', [$item_class, $filter_class, $animate_cls])); ?>" <?php pxl_print_html($data_settings); ?>>
                        <?php
                            do_action( 'woocommerce_before_shop_loop_item' );
                            do_action( 'woocommerce_before_shop_loop_item_title' );
                            do_action( 'woocommerce_shop_loop_item_title' );
                            do_action( 'woocommerce_after_shop_loop_item_title' );
                            do_action( 'woocommerce_after_shop_loop_item' );
                        ?>
                         
                    </div>
                <?php 
                }
                if($settings['layout_mode'] == 'masonry')
                    echo '<div class="grid-sizer '.$item_class.'"></div>';
            $html = ob_get_clean();
            wp_send_json(
                array(
                    'status' => true,
                    'message' => esc_html__('Load Post Grid Successfully!', 'adsett'),
                    'data' => array(
                        'html'  => $html,
                        'paged' => $settings['paged'],
                        'posts' => $posts,
                        'max' => $max,
                    ),
                )
            );
        }else{
            wp_send_json(
                array(
                    'status' => false,
                    'message' => esc_html__('Load Post Grid No More!', 'adsett')
                )
            );
        } 
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_adsett_load_more_post_grid', 'adsett_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_adsett_load_more_post_grid', 'adsett_load_more_post_grid' );
function adsett_load_more_post_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'adsett'));
        }
    
        $settings = isset($_POST['settings']) ? $_POST['settings'] : null;
        
        set_query_var('paged', $settings['paged']);
        extract(pxl_get_posts_of_grid($settings['post_type'], [
                'source' => isset($settings['source'])?$settings['source']:'',
                'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
                'order' => isset($settings['order'])?$settings['order']:'desc',
                'limit' => isset($settings['limit'])?$settings['limit']:'6',
                'post_ids' => isset($settings['post_ids'])?$settings['post_ids']: [],
                'post_not_in' => isset($settings['post_not_in'])?$settings['post_not_in']: [],
            ],
            $settings['tax']
        ));
        ob_start();
         
        adsett_get_post_grid($posts, $settings);
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'adsett'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}
 
function adsett_get_post_grid($posts = [], $settings = []){ 
    if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
        return;
    }
    extract($settings);

    $col_xxl = 'col-xxl-'.str_replace('.', '',12 / floatval( $settings['col_xxl']));
    $col_xl  = 'col-xl-'.str_replace('.', '',12 / floatval( $settings['col_xl']));
    $col_lg  = 'col-lg-'.str_replace('.', '',12 / floatval( $settings['col_lg']));
    $col_md  = 'col-md-'.str_replace('.', '',12 / floatval( $settings['col_md']));
    $col_sm  = 'col-sm-'.str_replace('.', '',12 / floatval( $settings['col_sm'])); 
    $col_xs  = 'col-'.str_replace('.', '',12 / floatval( $settings['col_xs'])); 

    $item_class = trim(implode(' ', ['grid-item', $col_xxl, $col_xl, $col_lg, $col_md, $col_sm, $col_xs]));

    $args_m = [];
    $settings['thumbnail'] = '';
    if($layout_mode == 'masonry') {  
        foreach ($posts as $key => $post){
            if( !empty($grid_custom_columns[$key]) ){
                $item_cls = $item_class;  
                $image_size = $img_size;
 
                $col_xxl_c = 'col-xxl-'.str_replace('.', '',12 / floatval($grid_custom_columns[$key]['col_xxl_c']));
                $col_xl_c = 'col-xl-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_xl_c']));
                $col_lg_c = 'col-lg-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_lg_c']));
                $col_md_c = 'col-md-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_md_c']));
                $col_sm_c = 'col-sm-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_sm_c'])); 
                $col_xs_c = 'col-xs-'.str_replace('.', '',12 / floatval( $grid_custom_columns[$key]['col_xs_c'])); 
                 
                $item_cls = trim(implode(' ', ['grid-item', $col_xxl_c, $col_xl_c, $col_lg_c, $col_md_c, $col_sm_c, $col_xs_c]));

                if( !empty($grid_custom_columns[$key]['img_size_c']) )
                    $image_size = $grid_custom_columns[$key]['img_size_c'];
           
                if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                    $img_id = get_post_thumbnail_id($post->ID);
                    if($img_id){
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                    }else{
                        $thumbnail = get_the_post_thumbnail($post->ID, $image_size);
                    }
                }
 
                $data_settings = '';
                if ( !empty( $grid_custom_columns[$key]['item_c_animation'] ) ) {

                    $item_cls.= ' pxl-animate pxl-invisible animated-'.$grid_custom_columns[$key]['item_c_animation_duration'];
                    $item_c_animation_delay = !empty($grid_custom_columns[$key]['item_c_animation_delay']) ? $grid_custom_columns[$key]['item_c_animation_delay'] : '100';
                    $data_animation =  json_encode([
                        'animation'      => $grid_custom_columns[$key]['item_c_animation'],
                        'animation_delay' => (float)$item_c_animation_delay
                    ]);
                    $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
                }


                $args_m[$key] = ['item_class' => $item_cls, 'thumbnail' => htmlspecialchars($thumbnail), 'data_setting' => $data_settings ];
            }else{
                $args_m[$key] = [];
            }
        }
    } 
    $settings['item_class'] = $item_class;
      
    switch ($layout) {
        case 'post-1':
            adsett_get_post_grid_layout1($posts, $settings, $args_m); 
            break;
        case 'post-2':
            adsett_get_post_grid_layout2($posts, $settings, $args_m); 
            break;
        case 'post-3':  
            adsett_get_post_grid_layout3($posts, $settings, $args_m); 
            break;
        case 'portfolio-1':  
            adsett_get_post_grid_portfolio1($posts, $settings, $args_m); 
            break;
        case 'portfolio-2':  
            adsett_get_post_grid_portfolio2($posts, $settings, $args_m); 
            break;
        case 'portfolio-list-1':
            adsett_get_portfolio_list_layout1($posts, $settings, $args_m);
            break;
        
        default:
            return false;
            break;
    }
    if($layout_mode == 'masonry'){
        echo '<div class="grid-sizer '.$item_class.'"></div>';
    }
     
}

function adsett_get_post_grid_layout1($posts = [], $settings = [], $args_m = []){ 
    extract($settings);  
    foreach ($posts as $key => $post):

        $str_item_class = !empty($args_m[$key]['item_class']) ? $args_m[$key]['item_class'] : $item_class;
         
        if(!empty($args_m[$key]['thumbnail'])){
            $thumbnail = wp_specialchars_decode($args_m[$key]['thumbnail'],ENT_QUOTES);
        }else{
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id){
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                }else{
                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size);
                }
            }
        }

        $filter_class = '';
        if ($select_post_by === 'term_selected' && $filter == "true")
            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
   
        $author = get_user_by('id', $post->post_author);
        $author_avatar = get_avatar( $post->post_author, 40, '', $author->display_name, array( 'class' => 'circle' ) ); 
        $comment_count = get_comments_number($post->ID);
        $button_text = !empty($button_text) ? $button_text : esc_html__('Read more', 'adsett');
        $date_format = get_option('date_format');

        $data_settings = '';
        $animate_cls = '';
        if ( !empty( $item_animation ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
            $data_animation =  json_encode([
                'animation'      => $item_animation,
                'animation_delay' => (float)$item_animation_delay
            ]);
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }

        if(!empty($args_m[$key]['anm_cls']))
            $animate_cls = $args_m[$key]['anm_cls'];

        if(!empty($args_m[$key]['data_setting']))
            $data_settings = $args_m[$key]['data_setting'];
        
        ?>
        <div class="<?php echo esc_attr($str_item_class. ' ' .$animate_cls. ' '. $filter_class); ?>" <?php pxl_print_html($data_settings); ?>>
            <div class="item-inner-wrap relative">
                <?php if (isset( $thumbnail )): ?>
                    <div class="item-featured relative">
                        <?php echo wp_kses_post($thumbnail); ?>
                        <div class="pxl-overlay"></div>
                        <?php if($show_button == 'true') : ?>
                            <div class="item-readmore">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="pxl-btn outline-above draw icon-ps-right">
                                    <span class="draw-top-right"></span>
                                    <span class="draw-bottom-left"></span>
                                    <span class="pxl-button-text"><?php pxl_print_html($button_text);?></span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <div class="item-content relative">
                    <div class="item-content-df">
                        <?php if( $show_author == 'true' || $show_date == 'true' || $show_category == 'true' ) : ?>
                            <div class="item-post-meta">
                                <div class="meta-inner d-flex align-items-center">
                                    <?php if( $show_author == 'true' ) : ?>
                                        <span class="post-author meta-item col-auto"><a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>"><?php echo esc_html($author->display_name); ?></a></span>
                                    <?php endif; ?>
                                    <?php if( $show_date == 'true' ) : ?>
                                        <span class="post-date meta-item col-auto"><?php echo get_the_date('d M', $post->ID); ?></span>
                                    <?php endif; ?>
                                    <?php if( $show_category == 'true' ) : ?>
                                        <div class="item-category col-auto"><?php the_terms( $post->ID, 'category', '', ' ' ); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <h4 class="item-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h4>
                    </div>
                    <div class="item-content-hover">
                        <?php if( $show_author == 'true' || $show_date == 'true' || $show_category == 'true' ) : ?>
                            <div class="item-post-meta">
                                <div class="meta-inner d-flex align-items-center">
                                    <?php if( $show_author == 'true' ) : ?>
                                        <span class="post-author meta-item col-auto"><a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>"><?php echo esc_html($author->display_name); ?></a></span>
                                    <?php endif; ?>
                                    <?php if( $show_date == 'true' ) : ?>
                                        <span class="post-date meta-item col-auto"><?php echo get_the_date($date_format, $post->ID); ?></span>
                                    <?php endif; ?>
                                    <?php if( $show_category == 'true' ) : ?>
                                        <div class="item-category"><?php the_terms( $post->ID, 'category', '', ' ' ); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="item-excerpt">
                                <?php
                                    if(!empty($post->post_excerpt)){
                                        echo wp_trim_words( $post->post_excerpt, $num_words, null );
                                    } else{
                                        $content = strip_shortcodes( $post->post_content );
                                        $content = apply_filters( 'the_content', $content );
                                        $content = str_replace(']]>', ']]&gt;', $content);
                                        echo wp_trim_words( $content, $num_words, null );
                                    }
                                ?> 
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php
    endforeach;
}

function adsett_get_post_grid_layout2($posts = [], $settings = [], $args_m = []){ 
    extract($settings);  
    $number = 1;
    foreach ($posts as $key => $post):
        $number = $number + $key;
        $str_item_class = !empty($args_m[$key]['item_class']) ? $args_m[$key]['item_class'] : $item_class;

        if(!empty($args_m[$key]['thumbnail'])){
            $thumbnail = wp_specialchars_decode($args_m[$key]['thumbnail'],ENT_QUOTES);
        }else{
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id){
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                }else{
                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size);
                }
            }
        }

        $filter_class = '';
        if ($select_post_by === 'term_selected' && $filter == "true")
            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
  
        
        $author = get_user_by('id', $post->post_author);
        $author_avatar = get_avatar( $post->post_author, 40, '', $author->display_name, array( 'class' => 'circle' ) ); 
        $comment_count = get_comments_number($post->ID);
        $button_text = !empty($button_text) ? $button_text : esc_html__('Read more', 'adsett');
        $date_format = get_option('date_format');
 
        $data_settings = '';
        $animate_cls = '';
        if ( !empty( $item_animation ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
            $data_animation =  json_encode([
                'animation'      => $item_animation,
                'animation_delay' => (float)$item_animation_delay 
            ]);
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }

        if(!empty($args_m[$key]['anm_cls']))
            $animate_cls = $args_m[$key]['anm_cls'];

        if(!empty($args_m[$key]['data_setting']))
            $data_settings = $args_m[$key]['data_setting'];

        ?>
        <div class="<?php echo esc_attr($str_item_class. ' '. $animate_cls . ' '. $filter_class); ?>" <?php pxl_print_html($data_settings); ?>>
            <div class="item-inner-wrap relative">
                <?php if (isset( $thumbnail )): ?>
                    <div class="item-featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                    </div>
                <?php endif; ?>
                <div class="item-content pxl-absoluted">
                    <div class="content-inner">
                        <?php if($show_date == 'true' || $show_author == 'true' || $show_category == 'true' ) : ?>
                            <div class="item-post-meta">
                                <div class="meta-inner d-flex align-items-end">
                                    <span class="number col-auto"><?php echo esc_attr($number) < 10 ? '0'.$number : $number; ?>/</span>
                                    <?php if( $show_author == 'true' ) : ?>
                                        <span class="post-author meta-item col-auto"><span class="avatar"><?php pxl_print_html($author_avatar) ?></span><a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>"><?php echo esc_html($author->display_name); ?></a></span>
                                    <?php endif; ?>
                                    <?php if( $show_date == 'true' ) : ?>
                                        <span class="post-date meta-item col-auto"><?php echo get_the_date('d M', $post->ID); ?></span>
                                    <?php endif; ?>
                                    <?php if( $show_category == 'true' ) : ?>
                                        <span class="post-category meta-item col-auto"><?php the_terms( $post->ID, 'category', '', ' ' ); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <h3 class="item-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php pxl_print_html(get_the_title($post->ID)); ?></a></h3>
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="item-excerpt">
                                <?php
                                    if(!empty($post->post_excerpt)){
                                        echo wp_trim_words( $post->post_excerpt, $num_words, null );
                                    } else{
                                        $content = strip_shortcodes( $post->post_content );
                                        $content = apply_filters( 'the_content', $content );
                                        $content = str_replace(']]>', ']]&gt;', $content);
                                        echo wp_trim_words( $content, $num_words, null );
                                    }
                                ?> 
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if($show_button == 'true') : ?>
                        <div class="item-readmore">
                            <a class="pxl-readmore-round-arrow-small" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span class="pxl-icon pxli pxli-next1"></span>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php
    endforeach;
}

function adsett_get_post_grid_layout3($posts = [], $settings = [], $args_m = []){ 
    extract($settings);  
    foreach ($posts as $key => $post):

        $str_item_class = !empty($args_m[$key]['item_class']) ? $args_m[$key]['item_class'] : $item_class;

        if(!empty($args_m[$key]['thumbnail'])){
            $thumbnail =  wp_specialchars_decode( $args_m[$key]['thumbnail'],ENT_QUOTES);
        }else{
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id){
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                }else{
                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size);
                }
            }
        }

        $filter_class = '';
        if ($select_post_by === 'term_selected' && $filter == "true")
            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
  
        $author = get_user_by('id', $post->post_author);
        $author_avatar = get_avatar( $post->post_author, 40, '', $author->display_name, array( 'class' => 'circle' ) ); 
        $comment_count = get_comments_number($post->ID);
        $button_text = !empty($button_text) ? $button_text : esc_html__('Read more', 'adsett');
        $date_format = get_option('date_format');

        $data_settings = '';
        $animate_cls = '';
        if ( !empty( $item_animation ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
            $data_animation =  json_encode([
                'animation'      => $item_animation,
                'animation_delay' => (float)$item_animation_delay
            ]);
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }

        if(!empty($args_m[$key]['anm_cls']))
            $animate_cls = $args_m[$key]['anm_cls'];

        if(!empty($args_m[$key]['data_setting']))
            $data_settings = $args_m[$key]['data_setting'];

        ?>
        <div class="<?php echo esc_attr($str_item_class. ' ' .$animate_cls. ' '.$filter_class ); ?>" <?php pxl_print_html($data_settings); ?>>
            <div class="grid-item-inner relative">
                <?php if (isset( $thumbnail )): ?>
                    <div class="item-featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                    </div>
                <?php endif; ?>
                <div class="item-content absolute row g-0">
                    <div class="content-inner col align-self-end">
                        <?php if( $show_date == 'true' ) : ?>
                            <div class="item-date meta-item">
                                <span class="pxl-icon pxli-calendar-alt-regular"></span><?php echo get_the_date($date_format, $post->ID); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="item-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                        <?php if( $show_author == 'true' ) : ?>
                            <div class="item-author meta-item">
                                <span class="avatar"><?php pxl_print_html($author_avatar) ?></span><a href="<?php echo esc_url(get_author_posts_url($post->post_author, $author->user_nicename)); ?>"><?php echo esc_html($author->display_name); ?></a>
                            </div>
                        <?php endif; ?>  
                        <?php if($show_excerpt == 'true'): ?>
                            <div class="item-excerpt">
                                <?php
                                    if(!empty($post->post_excerpt)){
                                        echo wp_trim_words( $post->post_excerpt, $num_words, null );
                                    } else{
                                        $content = strip_shortcodes( $post->post_content );
                                        $content = apply_filters( 'the_content', $content );
                                        $content = str_replace(']]>', ']]&gt;', $content);
                                        echo wp_trim_words( $content, $num_words, null );
                                    }
                                ?> 
                            </div>
                        <?php endif; ?>
                        <?php if($show_button == 'true') : ?>
                            <div class="item-readmore">
                                <a class="btn" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <span><?php pxl_print_html($button_text);?></span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php
    endforeach;
}
function adsett_get_post_grid_portfolio1($posts = [], $settings = [], $args_m = []){ 
    extract($settings);  
    foreach ($posts as $key => $post):

        $str_item_class = !empty($args_m[$key]['item_class']) ? $args_m[$key]['item_class'] : $item_class;

        if(!empty($args_m[$key]['thumbnail'])){
            $thumbnail = wp_specialchars_decode($args_m[$key]['thumbnail'],ENT_QUOTES);
        }else{
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id){
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                }else{
                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size);
                }
            }
        }

        $filter_class = '';
        if ($select_post_by === 'term_selected' && $filter == "true")
            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
 
          
         
        $data_settings = '';
        $animate_cls = '';
        if ( !empty( $item_animation ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
            $data_animation =  json_encode([
                'animation'      => $item_animation,
                'animation_delay' => (float)$item_animation_delay
            ]);
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }

        if(!empty($args_m[$key]['anm_cls']))
            $animate_cls = $args_m[$key]['anm_cls'];
 
        if(!empty($args_m[$key]['data_setting']))
            $data_settings = $args_m[$key]['data_setting'];

        $location = get_post_meta( $post->ID, 'location', true );

        $post_title = get_the_title($post->ID);
        $title_first = strstr($post_title, ' ', true);
        $title_last =  strstr($post_title, ' ', false);  
        ?>
        <div class="<?php echo esc_attr($str_item_class. ' ' .$animate_cls. ' '.$filter_class ); ?>" <?php pxl_print_html($data_settings); ?>>
            <div class="grid-item-inner relative" data-parallax='{"y": 30}'>
                <?php if (isset( $thumbnail )): ?>
                    <div class="item-featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <figure class="post-thumbs">
                            <?php echo wp_kses_post($thumbnail); ?>   
                            </figure> 
                        </a>
                    </div>
                <?php endif; ?>
                <h4 class="item-title font-body">
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                        <span class="ucfirst"><?php pxl_print_html($title_first) ?></span><?php pxl_print_html($title_last); ?>
                    </a>
                </h4> 
                <div class="pxl-bd-anm bb"></div>
                <div class="item-metas d-flex justify-content-between">
                    <?php if($show_category == 'true'): ?>
                        <div class="item-category">
                            <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if( !empty($location) ): ?>
                        <div class="item-location"><span class="pxl-icon pxli pxli-pin"></span><?php echo pxl_print_html($location) ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php
    endforeach;
}
function adsett_get_post_grid_portfolio2($posts = [], $settings = [], $args_m = []){ 
    extract($settings);  
    foreach ($posts as $key => $post):

        $str_item_class = !empty($args_m[$key]['item_class']) ? $args_m[$key]['item_class'] : $item_class;

        if(!empty($args_m[$key]['thumbnail'])){
            $thumbnail = wp_specialchars_decode($args_m[$key]['thumbnail'],ENT_QUOTES);
        }else{
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id){
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                }else{
                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size);
                }
            }
        }

        $filter_class = '';
        if ($select_post_by === 'term_selected' && $filter == "true")
            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
 
          
        $data_settings = '';
        $animate_cls = '';
        if ( !empty( $item_animation ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
            $data_animation =  json_encode([
                'animation'      => $item_animation,
                'animation_delay' => (float)$item_animation_delay
            ]);
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }
  
        if(!empty($args_m[$key]['anm_cls']))
            $animate_cls = $args_m[$key]['anm_cls'];

        if(!empty($args_m[$key]['data_setting']))
            $data_settings = $args_m[$key]['data_setting'];

        $location = get_post_meta( $post->ID, 'location', true );

        $post_title = get_the_title($post->ID);
        $title_first = strstr($post_title, ' ', true);
        $title_last =  strstr($post_title, ' ', false);  
        ?>
        <div class="<?php echo esc_attr($str_item_class. ' ' .$animate_cls. ' '.$filter_class ); ?>" <?php pxl_print_html($data_settings); ?>>
            <div class="grid-item-inner relative">
                <?php if (isset( $thumbnail )): ?>
                    <div class="item-featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <figure class="post-thumbs">
                            <?php echo wp_kses_post($thumbnail); ?>   
                            </figure> 
                        </a>
                    </div>
                <?php endif; ?>
                <h4 class="item-title">
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php pxl_print_html($post_title) ?></a>
                </h4> 
                <div class="pxl-bd-anm bb"></div>
                <div class="item-metas d-flex-wrap justify-content-between">
                    <?php if($show_category == 'true'): ?>
                        <div class="item-category">
                            <?php the_terms( $post->ID, 'portfolio-category', '', ' ' ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if( !empty($location) ): ?>
                        <div class="item-location"><span class="pxl-icon pxli pxli-pin"></span><?php echo pxl_print_html($location) ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php
    endforeach;
}

function adsett_get_portfolio_list_layout1($posts = [], $settings = [], $args_m = []){
    extract($settings);
    foreach ($posts as $key => $post):
        $str_item_class = !empty($args_m[$key]['item_class']) ? $args_m[$key]['item_class'] : $item_class;
        if(!empty($args_m[$key]['thumbnail'])){
            $thumbnail = wp_specialchars_decode($args_m[$key]['thumbnail'],ENT_QUOTES);
        }else{
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)){
                $img_id = get_post_thumbnail_id($post->ID);
                if($img_id){
                    $img = pxl_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $img_size,
                        'class' => 'img-desktop no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                }else{  
                    $thumbnail = get_the_post_thumbnail($post->ID, $img_size);
                }
            }else{
                $thumbnail = '';
            }
        }
        $filter_class = '';
        if ($select_post_by === 'term_selected' && $filter == "true")
            $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));

        $button_text = !empty($button_text) ? $button_text : esc_html__('View Details', 'adsett');

        $data_settings = '';
        $animate_cls = '';
        if ( !empty( $item_animation ) ) {
            $animate_cls = ' pxl-animate pxl-invisible animated-'.$item_animation_duration;
            $data_animation =  json_encode([
                'animation'      => $item_animation,
                'animation_delay' => (float)$item_animation_delay
            ]);
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }
  
        if(!empty($args_m[$key]['anm_cls']))
            $animate_cls = $args_m[$key]['anm_cls'];

        if(!empty($args_m[$key]['data_setting']))
            $data_settings = $args_m[$key]['data_setting'];

        $extra_desc = get_post_meta( $post->ID, 'extra_desc', true );

        $col_cls = !empty( $thumbnail ) ? 'col-12 col-lg-5 col-xl-5' : 'col';

        $item_idx_cls =  ($key + 1 )%2 === 0 ? 'item-idx-even' : 'item-idx-odd';

        if ( empty( $item_animation ) ) {
            if( ($key + 1 )%2 === 0 ){
                $data_animation =  json_encode([
                    'animation'      => 'fadeInLeft',
                    'animation_delay' => 150
                ]);
            }else{
                $data_animation =  json_encode([
                    'animation'      => 'fadeInRight',
                    'animation_delay' => 150
                ]);
            }
            $animate_cls = ' pxl-animate pxl-invisible animated-normal';
            $data_settings = 'data-settings="'.esc_attr($data_animation).'"';
        }
        ?>
        <div class="<?php echo esc_attr($str_item_class.' '. $filter_class.' '.$item_idx_cls); ?>" >
            <div class="grid-item-inner item-inner-wrap row align-items-center  gx-xl-70 <?php echo esc_attr($animate_cls) ?>" <?php pxl_print_html($data_settings); ?>>
                <?php 
                if ( !empty( $thumbnail )){
                    ?>
                    <div class="item-featured col-12 col-lg-7 col-xl-7">
                        <div class="post-image scale-hover">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <?php echo wp_kses_post($thumbnail); ?>       
                            </a>
                        </div>
                    </div>
                    <?php
                }
                ?>
                <div class="item-content <?php echo esc_attr($col_cls) ?>">
                    <h3 class="item-title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                    <?php if($show_excerpt == 'true'): ?>
                        <div class="item-excerpt">
                            <?php
                            if(!empty($extra_desc)){
                                echo wp_trim_words( $extra_desc, $num_words, null );
                            } else{
                                $content = strip_shortcodes( $post->post_content );
                                $content = apply_filters( 'the_content', $content );
                                $content = str_replace(']]>', ']]&gt;', $content);
                                echo wp_trim_words( $content, $num_words, null );
                            }
                            ?>
                        </div>
                    <?php endif; ?>
                    <?php if($show_button == 'true'): ?>
                        <div class="item-readmore">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" class="pxl-btn outline-under draw">
                                <span class="draw-top-right"></span>
                                <span class="draw-bottom-left"></span>
                                <span class="pxl-button-text"><?php pxl_print_html($button_text);?></span>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    endforeach; 
}

 
 



       