<?php
use Elementor\Controls_Manager;
use Elementor\Embed;
use Elementor\Group_Control_Image_Size;
 
if (!function_exists('adsett_elements_scripts')) {
    add_action('adsett_scripts', 'adsett_elements_scripts');
    function adsett_elements_scripts(){
        
        wp_enqueue_style( 'e-animations');

        wp_register_style( 'odometer', get_template_directory_uri() . '/elements/assets/css/odometer-theme-default.css', array(), '1.1.0');
        wp_register_style( 'twentytwenty', get_template_directory_uri() . '/elements/assets/css/twentytwenty.css', array(), '1.0.0');
 
        wp_enqueue_script( 'pxl-scroll-trigger', get_template_directory_uri() . '/elements/assets/js/libs/scroll-trigger.js', array( 'jquery' ), '3.10.5', true );
        wp_enqueue_script( 'pxl-parallax-background', get_template_directory_uri() . '/elements/assets/js/libs/parallax-background.js', array( 'jquery' ), adsett()->get_version(), true );
        wp_enqueue_script( 'pxl-parallax-scroll', get_template_directory_uri() . '/elements/assets/js/libs/parallax-scroll.js', array( 'jquery' ), adsett()->get_version(), true );
        wp_register_script( 'pxl-tilt', get_template_directory_uri() . '/elements/assets/js/libs/tilt.js', array( 'jquery' ), adsett()->get_version(), true );
        wp_register_script( 'pxl-splitText', get_template_directory_uri() . '/elements/assets/js/libs/split-text.js', array( 'jquery' ), '3.6.1', true );
        wp_register_script('odometter', get_template_directory_uri() . '/elements/assets/js/libs/odometer.min.js', [ 'jquery' ], adsett()->get_version(), true);

        wp_enqueue_script('adsett-elementor-edit', get_template_directory_uri() . '/elements/assets/js/pxl-elementor-edit.js', ['jquery'], adsett()->get_version(), true);
        wp_enqueue_script('adsett-elementor', get_template_directory_uri() . '/elements/assets/js/pxl-elementor.js', ['jquery'], adsett()->get_version(), true);
        wp_enqueue_script('adsett-elements', get_template_directory_uri() . '/elements/assets/js/pxl-elements.js', ['jquery'], adsett()->get_version(), true);
        wp_register_script('adsett-post-grid', get_template_directory_uri() . '/elements/assets/js/pxl-post-grid.js', ['isotope', 'jquery'], adsett()->get_version(), true);
        wp_localize_script('adsett-post-grid', 'main_data', array('ajax_url' => admin_url('admin-ajax.php')));
        wp_register_script('adsett-swiper', get_template_directory_uri() . '/elements/assets/js/pxl-swiper-carousel.js', ['jquery'], adsett()->get_version(), true);
        wp_register_script('adsett-swiper-slider', get_template_directory_uri() . '/elements/assets/js/pxl-swiper-slider.js', ['jquery'], adsett()->get_version(), true);
        wp_register_script('event-move', get_template_directory_uri() . '/elements/assets/js/libs/event.move.js', [ 'jquery' ], adsett()->get_version(), true);
        wp_register_script('twentytwenty', get_template_directory_uri() . '/elements/assets/js/libs/twentytwenty.js', [ 'jquery' ], adsett()->get_version(), true);
        
    }
}

 
 
if (!function_exists('adsett_register_custom_icon_library')) {
    add_filter('elementor/icons_manager/native', 'adsett_register_custom_icon_library');
    function adsett_register_custom_icon_library($tabs){
        $custom_tabs = [
            'adsett' => [
                'name' => 'adsett',
                'label' => esc_html__('Adsett', 'adsett'),
                'url' => false,
                'enqueue' => false,
                'prefix' => 'pxli-',
                'displayPrefix' => 'pxli',
                'labelIcon' => 'fas fa-user-plus',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/fonts/pixelart/pixelart.js',
                'native' => true,
            ],
            'flaticon' => [
                'name' => 'flaticon',
                'label' => esc_html__('Flaticon', 'adsett'),
                'url' => false,
                'enqueue' => false,
                'prefix' => 'flaticon-',
                'displayPrefix' => 'flaticon',
                'labelIcon' => 'fas fa-user-plus',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/fonts/flaticon/flaticon.js',
                'native' => true,
            ],
            'bootstrap' => [
                'name' => 'bootstrap',
                'label' => esc_html__('Bootstrap', 'adsett'),
                'url' => false,
                'enqueue' => false,
                'prefix' => 'bi-',
                'displayPrefix' => 'bi',
                'labelIcon' => 'fas fa-user-plus',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/fonts/bootstrap-icons/bootstrap-icons.js',
                'native' => true,
            ],
        ];
        $tabs = array_merge($custom_tabs, $tabs);
        return $tabs;
    }
}

if (!function_exists('adsett_get_class_widget_path')) {
    function adsett_get_class_widget_path(){
        $upload_dir = wp_upload_dir();
        $cls_path = $upload_dir['basedir'] . '/elementor-widget/';
        if (!is_dir($cls_path)) {
            wp_mkdir_p($cls_path);
        }
        return $cls_path;
    }
}

function adsett_get_post_type_options($pt_supports = []){
    $post_types = get_post_types([
        'public' => true,
    ], 'objects');
    $excluded_post_type = [
        'page',
        'attachment',
        'revision',
        'nav_menu_item',
        'custom_css',
        'customize_changeset',
        'oembed_cache',
        'e-landing-page',
        'product',
        'elementor_library'
    ];

    $result_some = [];
    $result_any = [];
    if (!is_array($post_types))
        return [];
    foreach ($post_types as $post_type) {
        if (!$post_type instanceof WP_Post_Type)
            continue;
        if (in_array($post_type->name, $excluded_post_type))
            continue;

        if (!empty($pt_supports) && in_array($post_type->name, $pt_supports)) {
            $result_some[$post_type->name] = $post_type->labels->singular_name;
        } else {
            $result_any[$post_type->name] = $post_type->labels->singular_name;
        }
    }

    if (!empty($pt_supports))
        return $result_some;
    else
        return $result_any;
}

/* post_grid functions */
function adsett_get_post_grid_layout($pt_supports = []){
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {
        $result[] = array(
            'name' => 'layout_' . $name,
            'label' => sprintf(esc_html__('Select Templates of %s', 'adsett'), $label),
            'type' => 'layoutcontrol',
            'default' => 'post-1',
            'options' => adsett_get_grid_layout_options($name),
            'prefix_class' => 'pxl-post-layout-',
            'condition' => [
                'post_type' => [$name]
            ]
        );
    }
    return $result;
}

function adsett_get_grid_layout_options($posttype_name){
    $option_layouts = [];
    switch ($posttype_name) {
        case 'portfolio':
            $option_layouts = [
                'portfolio-1' => [
                    'label' => esc_html__('Layout 1', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-portfolio-1.jpg'
                ],
                'portfolio-2' => [
                    'label' => esc_html__('Layout 2', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-portfolio-2.jpg'
                ]
            ];
            break;
        case 'post':
            $option_layouts = [
                'post-1' => [
                    'label' => esc_html__('Layout 1', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-layout1.jpg'
                ],
                'post-2' => [
                    'label' => esc_html__('Layout 2', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-layout2.jpg'
                ],
                'post-3' => [
                    'label' => esc_html__('Layout 3', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-layout3.jpg'
                ]
            ];
            break;
            
    }
    return $option_layouts;
}

//* post_list functions
function adsett_get_post_list_layout($pt_supports = []){
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {
        $result[] = array(
            'name' => 'layout_' . $name,
            'label' => sprintf(esc_html__('Select Templates of %s', 'adsett'), $label),
            'type' => 'layoutcontrol',
            'default' => 'portfolio-list-1',
            'options' => adsett_get_list_layout_options($name),
            'condition' => [
                'post_type' => [$name]
            ]
        );
    }
    return $result;
}

function adsett_get_list_layout_options($posttype_name){
    $option_layouts = [];
    switch ($posttype_name) {
        case 'portfolio':
            $option_layouts = [
                'portfolio-list-1' => [
                    'label' => esc_html__('Layout 1', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_list_portfolio-1.jpg'
                ],
            ];
            break;
    }
    return $option_layouts;
}

function adsett_get_grid_term_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $taxonomy = get_object_taxonomies($name, 'names');

        if ($name == 'post') $taxonomy = ['category'];
        if ($name == 'product') $taxonomy = ['product_cat'];

        $result[] = array(
            'name' => 'source_' . $name,
            'label' => sprintf(esc_html__('Select Term', 'adsett'), $label),
            'description' => esc_html__('Get all when no term selected', 'adsett'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => pxl_get_grid_term_options($name, $taxonomy),
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}

function adsett_get_grid_ids_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $posts = adsett_list_post($name, false);
 
        $result[] = array(
            'name' => 'source_' . $name . '_post_ids',
            'label' => sprintf(esc_html__('Select posts', 'adsett'), $label),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $posts,
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}
function adsett_get_grid_ids_unselected_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $posts = adsett_list_post($name, false);
 
        $result[] = array(
            'name' => 'source_' . $name . '_post_ids_unselected',
            'label' => sprintf(esc_html__('Unselected posts', 'adsett'), $label),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $posts,
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}
/* post_carousel functions */
function adsett_get_post_carousel_layout($pt_supports = []){
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {
        $result[] = array(
            'name' => 'layout_' . $name,
            'label' => sprintf(esc_html__('Select Templates of %s', 'adsett'), $label),
            'type' => 'layoutcontrol',
            'default' => 'post-1',
            'options' => adsett_get_carousel_layout_options($name),
            'prefix_class' => 'post-layout-',
            'condition' => [
                'post_type' => [$name]
            ]
        );
    }
    return $result;
}

function adsett_get_carousel_layout_options($posttype_name){
    $option_layouts = [];
    switch ($posttype_name) {
        case 'portfolio':
            $option_layouts = [
                'portfolio-1' => [
                    'label' => esc_html__('Layout 1', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_carousel_portfolio-1.jpg'
                ],
                'portfolio-2' => [
                    'label' => esc_html__('Layout 2', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_carousel_portfolio-2.jpg'
                ],
                'portfolio-3' => [
                    'label' => esc_html__('Layout 3', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_carousel_portfolio-3.jpg'
                ]
            ];
            break;
        case 'post':
            $option_layouts = [
                'post-1' => [
                    'label' => esc_html__('Layout 1', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-layout1.jpg'
                ],
                'post-2' => [
                    'label' => esc_html__('Layout 2', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-layout2.jpg'
                ],
                'post-3' => [
                    'label' => esc_html__('Layout 3', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_grid-layout3.jpg'
                ],
                'post-4' => [
                    'label' => esc_html__('Layout 4', 'adsett'),
                    'image' => get_template_directory_uri() . '/elements/assets/imgs/post_carousel-layout4.jpg'
                ]
            ];
            break;
    }
    return $option_layouts;
}

function adsett_get_carousel_term_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $taxonomy = get_object_taxonomies($name, 'names');

        if ($name == 'post') $taxonomy = ['category'];
        if ($name == 'product') $taxonomy = ['product_cat'];

        $result[] = array(
            'name' => 'source_' . $name,
            'label' => sprintf(esc_html__('Select Term', 'adsett'), $label),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => pxl_get_grid_term_options($name, $taxonomy),
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}

function adsett_get_carousel_ids_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $posts = adsett_list_post($name, false);
 
        $result[] = array(
            'name' => 'source_' . $name . '_post_ids',
            'label' => sprintf(esc_html__('Select posts', 'adsett'), $label),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $posts,
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}
function adsett_get_carousel_ids_unselected_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = adsett_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $posts = adsett_list_post($name, false);
 
        $result[] = array(
            'name' => 'source_' . $name . '_post_ids_unselected',
            'label' => sprintf(esc_html__('Unselected posts', 'adsett'), $label),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $posts,
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}

/* grid columns setting */
function adsett_grid_column_settings(){
    $options = [
        '12' => '12',
        '6'  => '6',
        '5'  => '5',
        '4'  => '4',
        '3'  => '3',
        '2'  => '2',
        '1'  => '1',
        '1.5'  => '2/3',
        ''   => esc_html__( 'Default Layout', 'adsett' )
    ];
    return array(
        array(
            'name'    => 'col_xs',
            'label'   => esc_html__( 'Extra Small <= 575', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_sm',
            'label'   => esc_html__( 'Small <= 767', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_md',
            'label'   => esc_html__( 'Medium <= 991', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_lg',
            'label'   => esc_html__( 'Large <= 1199', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_xl',
            'label'   => esc_html__( 'XL Devices >= 1200', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_xxl',
            'label'   => esc_html__( 'XXL Devices >= 1400', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        )
    );
}

function adsett_grid_custom_column_settings(){
    $options = [
        '12' => '12',
        '6'  => '6',
        '5'  => '5',
        '4'  => '4',
        '3'  => '3',
        '2'  => '2',
        '1'  => '1',
        '1.5'  => '2/3',
    ];
    return array(
        array(
            'name'    => 'col_xs_c',
            'label'   => esc_html__( 'Extra Small <= 575', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => '1',
            'options' => $options
        ),
        array(
            'name'    => 'col_sm_c',
            'label'   => esc_html__( 'Small <= 767', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => '2',
            'options' => $options
        ),
        array(
            'name'    => 'col_md_c',
            'label'   => esc_html__( 'Medium <= 991', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => '2',
            'options' => $options
        ),
        array(
            'name'    => 'col_lg_c',
            'label'   => esc_html__( 'Large <= 1199', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => '3',
            'options' => $options
        ),
        array(
            'name'    => 'col_xl_c',
            'label'   => esc_html__( 'XL Devices >= 1200', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => '4',
            'options' => $options
        ),
        array(
            'name'    => 'col_xxl_c',
            'label'   => esc_html__( 'XXL Devices >= 1400', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => '5',
            'options' => $options
        )
    );
}

/* carousel columns setting */
function adsett_carousel_column_settings(){
    $options = [
        '12' => '12',
        '6'  => '6',
        '5'  => '5',
        '4'  => '4',
        '3'  => '3',
        '2'  => '2',
        '1'  => '1'
    ];
    return array(
        array(
            'name'    => 'col_xs',
            'label'   => esc_html__( 'Extra Small <= 575', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_sm',
            'label'   => esc_html__( 'Small <= 767', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_md',
            'label'   => esc_html__( 'Medium <= 991', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_lg',
            'label'   => esc_html__( 'Large <= 1199', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_xl',
            'label'   => esc_html__( 'XL Devices >= 1200', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        ),
        array(
            'name'    => 'col_xxl',
            'label'   => esc_html__( 'XXL Devices >= 1400', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'options' => $options
        )
    );
}

function adsett_elementor_animation_opts($args = []){
    $args = wp_parse_args($args, [
        'name'   => '',
        'label'  => '',
        'condition'   => [],
    ]);

    return array(
        array(
            'name'      => $args['name'].'_animation',
            'label'     => $args['label'].' '.esc_html__( 'Motion Effect', 'adsett' ),
            'type'      => \Elementor\Controls_Manager::ANIMATION,
            'condition'   => $args['condition'],
        ),
        array(
            'name'    => $args['name'].'_animation_duration', 
            'label'   => $args['label'].' '.esc_html__( 'Animation Duration', 'adsett' ),
            'type'    => \Elementor\Controls_Manager::SELECT,
            'default' => 'normal',
            'options' => [
                'slow'   => esc_html__( 'Slow', 'adsett' ),
                'normal' => esc_html__( 'Normal', 'adsett' ),
                'fast'   => esc_html__( 'Fast', 'adsett' ),
            ],
            'condition'   => array_merge($args['condition'], [ $args['name'].'_animation!' => '' ]),
            
        ),
        array(
            'name'      => $args['name'].'_animation_delay',
            'label'     => $args['label'].' '.esc_html__( 'Animation Delay', 'adsett' ),
            'type'      => \Elementor\Controls_Manager::NUMBER,
            'min'       => 0,
            'step'      => 100,
            'condition'   => array_merge($args['condition'], [ $args['name'].'_animation!' => '' ]),
        )
    );
}

function adsett_position_option($args = []){
    $start = is_rtl() ? esc_html__( 'Right', 'adsett' ) : esc_html__( 'Left', 'adsett' );
    $end = ! is_rtl() ? esc_html__( 'Right', 'adsett' ) : esc_html__( 'Left', 'adsett' );
    $args = wp_parse_args($args, [
        'prefix' => '',
        'selectors_class' => '',
        'condition' => []
    ]);
    $options = array(
        array(
            'name'        => $args['prefix'] .'position',
            'label' => ucfirst( str_replace('_', ' ', $args['prefix']) ).' '.esc_html__( 'Position', 'adsett' ),
            'type' => \Elementor\Controls_Manager::SELECT,
            'control_type' => 'responsive',
            'default' => '',
            'options' => [
                'relative' => esc_html__( 'Default', 'adsett' ),
                'absolute' => esc_html__( 'Absolute', 'adsett' ),
            ],
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'position: {{VALUE}}',
            ],
            'frontend_available' => true,
            'condition'   => $args['condition'],
        ),
         
        array(
            'name'        => $args['prefix'] .'pos_offset_left',
            'label' => esc_html__( 'Left', 'adsett' ).' (50px) px,%,vw,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'left: {{VALUE}}',
            ],
            'condition'   => array_merge($args['condition'], [ $args['prefix'] .'position!' => '' ]),
        ),  
        array(
            'name'        => $args['prefix'] .'pos_offset_right',
            'label' => esc_html__( 'Right', 'adsett' ).' (50px) px,%,vw,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'right: {{VALUE}}',
            ],
            'condition'   => array_merge($args['condition'], [ $args['prefix'] .'position!' => '' ]),
             
        ),
        array(
            'name'        => $args['prefix'] .'pos_offset_top',
            'label' => esc_html__( 'Top', 'adsett' ).' (50px) px,%,vh,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'top: {{VALUE}}',
            ],
            'condition'   => array_merge($args['condition'], [ $args['prefix'] .'position!' => '']),
              
        ),  
        array(
            'name'        => $args['prefix'] .'pos_offset_bottom',
            'label' => esc_html__( 'Bottom', 'adsett' ).' (50px) px,%,vh,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'bottom: {{VALUE}}',
            ],
            'condition'   => array_merge($args['condition'], [ $args['prefix'] .'position!' => '']),
        ),
        array(
            'name'        => $args['prefix'] .'z_index',
            'label' => ucfirst( str_replace('_', ' ', $args['prefix']) ).' '. esc_html__( 'Z-Index', 'adsett' ),
            'type' => Controls_Manager::NUMBER,
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'z-index: {{VALUE}};',
            ],
            'condition'   => array_merge($args['condition'], [ $args['prefix'] .'position!' => '' ]),
        )
    );
    return $options;
}
function adsett_position_option_base($args = []){
    $args = wp_parse_args($args, [
        'prefix' => '',
        'selectors_class' => '',
        'condition' => []
    ]);
    $options = array(
        array(
            'name'         => $args['prefix'] .'position_popover',
            'label'        => ucfirst( str_replace('_', ' ', $args['prefix']) ).' '. esc_html__( 'Position', 'adsett' ),
            'type'         => Controls_Manager::POPOVER_TOGGLE,
            'label_off'    => esc_html__( 'Default', 'adsett' ),
            'label_on'     => esc_html__( 'Custom', 'adsett' ),
            'return_value' => 'yes',
            'condition'    => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'] .'pxl_start_popover',
            'label'       => ucfirst( str_replace('_', '', $args['prefix']) ).' '. esc_html__( 'Start Popover', 'adsett' ),
            'type'        => 'pxl_start_popover',
            'condition'   => $args['condition'],
        ), 
         
        array(
            'name'        => $args['prefix'] .'pos_offset_left',
            'label' => esc_html__( 'Left', 'adsett' ).' (50px) px,%,vw,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'left: {{VALUE}}',
            ],
            'condition'   => $args['condition'],
        ),  
        array(
            'name'        => $args['prefix'] .'pos_offset_right',
            'label' => esc_html__( 'Right', 'adsett' ).' (50px) px,%,vw,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'right: {{VALUE}}',
            ],
            'condition'   => $args['condition'],
             
        ),
        array(
            'name'        => $args['prefix'] .'pos_offset_top',
            'label' => esc_html__( 'Top', 'adsett' ).' (50px) px,%,vh,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'top: {{VALUE}}',
            ],
            'condition'   => $args['condition'],
              
        ),  
        array(
            'name'        => $args['prefix'] .'pos_offset_bottom',
            'label' => esc_html__( 'Bottom', 'adsett' ).' (50px) px,%,vh,auto',
            'type' => 'text',
            'default' => '',
            'control_type' => 'responsive',
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => 'bottom: {{VALUE}}',
            ],
            'condition'   => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'] .'pxl_end_popover',
            'label'       => ucfirst( str_replace('_', '', $args['prefix']) ).' '. esc_html__( 'End Popover', 'adsett' ),
            'type'        => 'pxl_end_popover',
            'condition'   => $args['condition'],
        )
        
    );
    return $options;
}
function adsett_transform_option($args = []){
    $transform_prefix_class = 'pxl-';
    $transform_return_value = 'transform';
    $args = wp_parse_args($args, [
        'prefix' => '',
        'selectors_class' => '',
        'condition' => []
    ]);
    $options = array(
        array(
            'name'        => $args['prefix'] .'transform_translate_popover',
            'label' => ucfirst( str_replace('_', ' ', $args['prefix']) ).' '. esc_html__( 'Transform', 'adsett' ),
            'type' => Controls_Manager::POPOVER_TOGGLE,
            'prefix_class' => $transform_prefix_class,
            'return_value' => $transform_return_value,
            'condition'   => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'] .'pxl_start_popover',
            'label'       => ucfirst( str_replace('_', '', $args['prefix']) ).' '. esc_html__( 'Start Popover', 'adsett' ),
            'type'        => 'pxl_start_popover',
            'condition'   => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'] .'transform_translateX_effect',
            'label' => esc_html__( 'Offset X', 'adsett' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ '%', 'px' ],
            'range' => [
                '%' => [
                    'min' => -100,
                    'max' => 100,
                ],
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                ],
            ],
            'control_type' => 'responsive',
            'condition' => [
                $args['prefix'] .'transform_translate_popover!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => '--pxl-transform-translateX: {{SIZE}}{{UNIT}};',
            ],
            'frontend_available' => true,
        ),
        array(
            'name'        => $args['prefix'] .'_transform_translateY_effect',
            'label' => esc_html__( 'Offset Y', 'adsett' ),
            'type' => Controls_Manager::SLIDER,
            'size_units' => [ '%', 'px' ],
            'range' => [
                '%' => [
                    'min' => -100,
                    'max' => 100,
                ],
                'px' => [
                    'min' => -1000,
                    'max' => 1000,
                ],
            ],
            'control_type' => 'responsive',
            'condition' => [
                $args['prefix'] .'transform_translate_popover!' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} '.$args['selectors_class'] => '--pxl-transform-translateY: {{SIZE}}{{UNIT}};',
            ],
            'frontend_available' => true,
        ),
        array(
            'name'        => $args['prefix'] .'pxl_end_popover',
            'label'       => ucfirst( str_replace('_', '', $args['prefix']) ).' '. esc_html__( 'End Popover', 'adsett' ),
            'type'        => 'pxl_end_popover',
            'condition'   => $args['condition'],
        ),
    );
    return $options;
}

function adsett_parallax_effect_option($args = []){
     
    $args = wp_parse_args($args, [
        'prefix' => '',
        'condition' => []
    ]);
    $options = array(
        array(
            'name'         => $args['prefix'] .'parallax_effect_popover',
            'label'        => ucfirst( str_replace('_', ' ', $args['prefix']) ).' '. esc_html__( 'Parallax Effect', 'adsett' ),
            'type'         => Controls_Manager::POPOVER_TOGGLE,
            'label_off'    => esc_html__( 'Default', 'adsett' ),
            'label_on'     => esc_html__( 'Custom', 'adsett' ),
            'return_value' => 'yes',
            'condition'    => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'] .'pxl_start_popover',
            'label'       => ucfirst( str_replace('_', '', $args['prefix']) ).' '. esc_html__( 'Start Popover', 'adsett' ),
            'type'        => 'pxl_start_popover',
            'condition'   => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_x',
            'label'     => esc_html__( 'TranslateX', 'adsett' ).' (-80)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_y',
            'label'     => esc_html__( 'TranslateY', 'adsett' ).' (-80)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_z',
            'label'     => esc_html__( 'TranslateZ', 'adsett' ).' (-80)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_rotate_x',
            'label'     => esc_html__( 'Rotate X', 'adsett' ).' (30)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_rotate_y',
            'label'     => esc_html__( 'Rotate Y', 'adsett' ).' (30)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_rotate_z',
            'label'     => esc_html__( 'Rotate Z', 'adsett' ).' (30)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_scale_x',
            'label'     => esc_html__( 'Scale X', 'adsett' ).' (0.8)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_scale_y',
            'label'     => esc_html__( 'Scale Y', 'adsett' ).' (0.8)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_scale_z',
            'label'     => esc_html__( 'Scale Z', 'adsett' ).' (0.8)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'      => $args['prefix'] .'parallax_effect_scale',
            'label'     => esc_html__( 'Scale', 'adsett' ).' (0.8)', 
            'type'      => Controls_Manager::NUMBER,
            'default'   => '',
            'condition' => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'] .'pxl_end_popover',
            'label'       => ucfirst( str_replace('_', '', $args['prefix']) ).' '. esc_html__( 'End Popover', 'adsett' ),
            'type'        => 'pxl_end_popover',
            'condition'   => $args['condition'],
        ), 
       
    );
    return $options;
}

function adsett_get_parallax_effect($settings = []){
    $effects = [];
    if(!empty($settings['layer_parallax_effect_x'])){
        $effects['x'] = (int)$settings['layer_parallax_effect_x'];
    }
    if(!empty($settings['layer_parallax_effect_y'])){
        $effects['y'] = (int)$settings['layer_parallax_effect_y'];
    }
    if(!empty($settings['layer_parallax_effect_z'])){
        $effects['y'] = (int)$settings['layer_parallax_effect_z'];
    }
    if(!empty($settings['layer_parallax_effect_rotate_x'])){
        $effects['rotateX'] = (float)$settings['layer_parallax_effect_rotate_x'];
    }
    if(!empty($settings['layer_parallax_effect_rotate_y'])){
        $effects['rotateY'] = (float)$settings['layer_parallax_effect_rotate_y'];
    }
    if(!empty($settings['layer_parallax_effect_rotate_z'])){
        $effects['rotateY'] = (float)$settings['layer_parallax_effect_rotate_z'];
    }
    if(!empty($settings['layer_parallax_effect_scale_x'])){
        $effects['scaleX'] = (float)$settings['layer_parallax_effect_scale_x'];
    }
    if(!empty($settings['layer_parallax_effect_scale_y'])){
        $effects['scaleY'] = (float)$settings['layer_parallax_effect_scale_y'];
    }
    if(!empty($settings['layer_parallax_effect_scale_z'])){
        $effects['scaleZ'] = (float)$settings['layer_parallax_effect_scale_z'];
    }
    if(!empty($settings['layer_parallax_effect_scale'])){
        $effects['scale'] = (float)$settings['layer_parallax_effect_scale'];
    }

    return json_encode($effects);
}

function adsett_button_settings($args = []){
    $args = wp_parse_args($args, [
        'prefix'                => '',
        'condition'             => [],
        'btn_text'              => ''
    ]);
    return array(
        array(
            'name'    => $args['prefix'].'style',
            'label'   => esc_html__( 'Button Style', 'adsett' ),
            'type'    => 'select',
            'default' => 'default',
            'options' => [
                'default'        => esc_html__( 'Default', 'adsett' ),
                'outline-under'  => esc_html__( 'Border outline under', 'adsett' ),
                'outline-above'  => esc_html__( 'Border outline above', 'adsett' ),
                'outline-around' => esc_html__( 'Border outline around', 'adsett' ),
            ],
            'condition'   => $args['condition'],
        ),
        array(
            'name'    => $args['prefix'].'border_hover_style',
            'label'   => esc_html__( 'Border Hover Style', 'adsett' ),
            'type'    => 'select',
            'default' => 'transform',
            'options' => [
                'transform' => esc_html__( 'Transform', 'adsett' ),
                'draw'      => esc_html__( 'Draw', 'adsett' ),
            ],
            'condition'   => $args['condition'],
        ),
        array(
            'name'        => $args['prefix'].'text',
            'label'       => esc_html__('Text', 'adsett' ),
            'type'        => \Elementor\Controls_Manager::TEXT,
            'default'     => $args['btn_text'],
            'placeholder' => esc_html__('Click here', 'adsett'),
        ),
        array(
            'name' => $args['prefix'].'link',
            'label' => esc_html__('Link', 'adsett'),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => esc_html__('https://your-link.com', 'adsett' ),
            'default' => [
                'url' => '#',
            ],
        )
    );
}
function pxl_get_product_grid_term_options($args=[]){
    $product_categories = get_categories(array( 'taxonomy' => 'product_cat' ));
    $options = array();
    foreach($product_categories as $category){
        $options[$category->slug] = $category->name;
    }
    return $options;
}

function adsett_cursor_opts(){
    $enable_cursor = adsett()->get_opt('enable_cursor', '0');
    if($enable_cursor == '0') return;
    return array(
        'name' => 'carousel_setting_cursor',
        'label' => esc_html__('Cursor Settings', 'adsett' ),
        'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
        'controls' =>  array( 
            array(
                'name' => 'cursor_arrow',
                'label' => esc_html__('Cursor Arrow', 'adsett'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'condition' => ['arrows' => 'true']
            ),
            array(
                'name' => 'cursor_drag',
                'label' => esc_html__('Cursor Drag', 'adsett'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
            )
            
        )
    );
}

function adsett_get_img_link_url( $settings ) {
    if ( 'none' === $settings['link_to'] ) {
        return false;
    }

    if ( 'custom' === $settings['link_to'] ) {
        if ( empty( $settings['link']['url'] ) ) {
            return false;
        }

        return $settings['link'];
    }

    return [
        'url' => $settings['image']['url'],
    ];
}