( function( $ ) {
 
    var PXLTabsHandler = function( $scope, $ ) {
        $scope.find(".pxl-tabs .tabs-title .tab-title").on("click", function(e){
            e.preventDefault();
            var target = $(this).data("target");
            $(this).addClass('active').siblings().removeClass('active');
            $(target).addClass('active').siblings().removeClass('active'); 
            $(target).siblings().find('.pxl-animate').each(function(){
                var data = $(this).data('settings');
                $(this).removeClass('animated '+data['animation']).addClass('pxl-invisible');
            });
            $(target).find('.pxl-animate').each(function(){
                var data = $(this).data('settings');
                var cur_anm = $(this);
                setTimeout(function () {  
                    $(cur_anm).removeClass('pxl-invisible').addClass('animated ' + data['animation']);
                }, data['animation_delay']);

            });
        });
    };

    var Pxl_Tablist_Animation_Handler = function( $scope, $ ) {
        $scope.find('.tl-item').on({
            mouseenter: function mouseenter() {  
                $(this).addClass('active');
                $(this).siblings('.tl-item').removeClass('active');
            },
        });
    };

    function adsett_gallery_handler( $scope) {
        $scope.find('.pxl-gallery-grid .pxl-grid-masonry').imagesLoaded(function(){
            if($(document).find('.elementor-editor-active').length > 0){
                let oldHTMLElement = HTMLElement;
                window.HTMLElement = window.parent.HTMLElement;
                $scope.find('.pxl-grid-masonry').each(function () {    
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                    
                });
                window.HTMLElement = oldHTMLElement;
            }else{
                $scope.find('.pxl-grid-masonry').each(function () {   
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                    
                });
            }
        });

        var galleries = $scope.find(".pxl-gallery-grid"),
            data_show = galleries.data('show'),
            data_load = galleries.data('loadmore');
        galleries.find(".grid-item").slice(0, data_show).show();
        galleries.find('.pxl-gallery-load').on('click',  function(e) { // click event for load more
            e.preventDefault();
            galleries.find(".grid-item:hidden").slice(0, data_load).show(100); // select next 10 hidden divs and show them
            if (galleries.find(".grid-item:hidden").length == 0) { // check if any hidden divs still exist
                $(this).closest('.load-more-wrap').hide();
            } 
            setTimeout(function(){
                $scope.find('.pxl-grid-masonry').each(function () {    
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                });
            }, 100);
            
        });
    };
      
    function adsett_cound_down_handler($scope){
        if ($scope.find('.pxl-countdown-container').length > 0) {
            var $this = $scope.find('.pxl-countdown-container');
            var timeout = $this.data('time');
            
            if(timeout == ''){
                var current = new Date();
                var end = new Date(current.getTime() + (13*24*60*60*1000));
            }else{
                var end = new Date(timeout);
            }

            var _second = 1000;
            var _minute = _second * 60;
            var _hour = _minute * 60;
            var _day = _hour * 24;
            var timer = setInterval(function () {
                var now = new Date();
                var distance = end - now;
                if (distance > 0) {
                    var days = Math.floor(distance / _day);
                    var hours = Math.floor((distance % _day) / _hour);
                    var minutes = Math.floor((distance % _hour) / _minute);
                    var seconds = Math.floor((distance % _minute) / _second);
                    $this.find('.day').html(days < 10 ? '0' + days : days);
                    $this.find('.hour').html(hours < 10 ? '0' + hours : hours);
                    $this.find('.minute').html(minutes < 10 ? '0' + minutes : minutes);
                    $this.find('.second').html(seconds < 10 ? '0' + seconds : seconds);
                    return;
                }
                clearInterval(timer);
            }, 1000);
            //})
        }
    }

    function adsett_accordion_handler($scope){
        $scope.find(".pxl-accordion .ac-item").on("click", function(e){
            e.preventDefault();
            var target = $(this).data("target");
            var parent = $(this).parent(".pxl-accordion");
            var active_items = parent.find(".ac-item.active");
            $.each(active_items, function (index, item) {
                var item_target = $(item).data("target");
                if(item_target != target){
                    $(item).removeClass("active");
                    $(item_target).slideUp(400);
                }
            });
            $(this).toggleClass("active");
            $(target).slideToggle(400);
        });
    }

    function adsett_video_gallery_handler( $scope) {
        $scope.find('.pxl-video-gallery-grid .pxl-grid-masonry').imagesLoaded(function(){
            if($(document).find('.elementor-editor-active').length > 0){
                let oldHTMLElement = HTMLElement;
                window.HTMLElement = window.parent.HTMLElement;
                $scope.find('.pxl-grid-masonry').each(function () {    
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                    
                });
                window.HTMLElement = oldHTMLElement;
            }else{
                $scope.find('.pxl-grid-masonry').each(function () {   
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                    
                });
            }
        });

        var galleries = $scope.find(".pxl-video-gallery-grid"),
            data_show = galleries.data('show'),
            data_load = galleries.data('loadmore');
        galleries.find(".grid-item").slice(0, data_show).show();
        galleries.find('.pxl-gallery-load').on('click',  function(e) { // click event for load more
            e.preventDefault();
            galleries.find(".grid-item:hidden").slice(0, data_load).show(100); // select next 10 hidden divs and show them
            if (galleries.find(".grid-item:hidden").length == 0) { // check if any hidden divs still exist
                $(this).closest('.load-more-wrap').hide();
            } 
            setTimeout(function(){
                $scope.find('.pxl-grid-masonry').each(function () {    
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                });
            }, 100);
            
        });
    };

    function adsett_service_grid_handler( $scope) {

        $scope.find('.pxl-service-grid .pxl-grid-masonry').imagesLoaded(function(){
            if($(document).find('.elementor-editor-active').length > 0){
                let oldHTMLElement = HTMLElement;
                window.HTMLElement = window.parent.HTMLElement;
                $scope.find('.pxl-grid-masonry').each(function () {    
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                    
                });
                window.HTMLElement = oldHTMLElement;
            }else{
                $scope.find('.pxl-grid-masonry').each(function () {   
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                    
                });
            }
        });
         

        var galleries = $scope.find(".pxl-service-grid"),
            data_show = galleries.data('show'),
            data_load = galleries.data('loadmore');
        galleries.find(".grid-item").slice(0, data_show).show();
        galleries.find('.pxl-gallery-load').on('click',  function(e) { // click event for load more
            e.preventDefault();
            galleries.find(".grid-item:hidden").slice(0, data_load).show(100); // select next 10 hidden divs and show them
            if (galleries.find(".grid-item:hidden").length == 0) { // check if any hidden divs still exist
                $(this).closest('.load-more-wrap').hide();
            } 
            setTimeout(function(){
                $scope.find('.pxl-grid-masonry').each(function () {    
                    var iso = new Isotope(this, {
                        itemSelector: '.grid-item',
                        layoutMode: $(this).closest('.pxl-grid').attr('data-layout-mode'),   
                        fitRows: {
                            gutter: 0
                        },
                        percentPosition: true,
                        masonry: {
                            columnWidth: '.grid-sizer',
                        },
                        containerStyle: null,
                        stagger: 30,
                        sortBy : 'name',
                    });
                });
            }, 100);
            
        });
    };

    function adsett_image_before_after_handler($scope){
        $scope.find(".twentytwenty-container[data-orientation!='vertical']").twentytwenty({default_offset_pct: 0.5});
        $scope.find(".twentytwenty-container[data-orientation='vertical']").twentytwenty({default_offset_pct: 0.5, orientation: 'vertical'});
    } 
    
    function adsett_progressbar_handler($scope){
        elementorFrontend.waypoint($scope.find('.pxl-progress-bar'), function () {
            $(this).progressbar();
        });
        elementorFrontend.waypoint($scope.find('.pxl-progressbar.circle'), function () {
            var $progressbarElem = $scope.find(".pxl-progressbar-container"),
                $progressbarElemInner = $scope.find(".pxl-progressbar-inner"),
                settings = $progressbarElem.data("settings"),
                length = settings.circle_percent,
                number = settings.circle_number,
                prefix = settings.prefix,
                suffix = settings.suffix,
                speed = settings.speed;
            if (length > 100)
                length = 100;
             
            $progressbarElem.prop({
                'percent': 0
            }).animate({
                percent: length
            }, {
                duration: speed,
                easing: 'linear',
                step: function (percent) {
                    var rotate = (percent * 3.6);
                    $progressbarElem.find(".pxl-progressbar-circle-left").css('transform', "rotate(" + rotate + "deg)");
                    if ( rotate > 180) {
                        $progressbarElem.find(".pxl-progressbar-circle").css({
                            '-webkit-clip-path': 'inset(0)',
                            'clip-path': 'inset(0)',
                        });
                        $progressbarElem.find(".pxl-progressbar-circle-right").css('visibility', 'visible');
                    }
                }
            });

            $progressbarElemInner.prop({
                'counter': 0,
            }).animate({
                counter: number,
            }, {
                duration: speed,
                easing: 'linear',
                step: function (counter) {
                    $progressbarElem.find(".progress-percentage").text(prefix + Math.ceil(counter) + suffix);
                }
            });
             
        });
    }

    function adsett_counter_handler($scope){
        setTimeout(function(){
            elementorFrontend.waypoint($scope.find('.pxl-counter-number-value'), function () {
                var $number = $(this),
                    data = $number.data();
                var el = $number[0];
                var startNumber = data['startnumber'], endNumber = data['endnumber'], separator = data['delimiter'], duration = data['duration'] ;
                od = new Odometer({
                    el: el,
                    value: startNumber,
                    format: separator,
                    theme: 'default'
                });
                od.update(endNumber);
            });
        }, 150);
    }
    function adsett_title_scroll_effect_handler($scope){
        /*gsap.registerPlugin(ScrollTrigger, Observer);

        let sections = gsap.utils.toArray(".testccc .pxl-title-effect");
        let dragRatio = 1;
        let scrollTo;

        let scrollTween = gsap.to(sections, {
            xPercent: -100 * (sections.length - 2.5),
            ease: "easeInOut",
            scrollTrigger: {
                trigger: "#works",
                pin: true,
                scrub: 1,
                // snap: 1 / (sections.length - 1),
                toggleClass: 'enable',
                end: () => "+=" + (document.querySelector(".testccc").offsetWidth - sections[0].offsetWidth),
                onRefresh: (self) => {
                    dragRatio =
                            (self.end - self.start) /
                            ((sections.length - 1) * sections[0].offsetWidth);
                }
            }
        });

        Observer.create({
            target: ".testccc",
            type: "wheel,touch,pointer",
            onPress: (self) => {
              self.startScroll = scrollTween.scrollTrigger.scroll();
              scrollTo = gsap.quickTo(scrollTween.scrollTrigger, "scroll", {
                duration: 0.5,
                ease: "power3"
              });
            },
            onDrag: (self) => {
              scrollTo(self.startScroll + (self.startX - self.x) * dragRatio);
            }
        });

        const works = document.querySelector("#works");

        let texts = gsap.utils.toArray(".testccc .pxl-item-title")

        texts.forEach((text, i) => {

            gsap.fromTo(text, {
                objectPosition: "30% top"
            },
            {
                objectPosition: "80% top",
                ease: "none",
                scrollTrigger: {
                    trigger: text,
                    scrub: true,
                    start: "left right",
                    end: "right left",
                    markers: true
                }
            })
        })*/
        gsap.registerPlugin(ScrollTrigger);
        const images = gsap.utils.toArray('img');  
        const showDemo = () => {
            document.body.style.overflow = 'auto';
            gsap.utils.toArray($scope.find('.pxl-horizontal-scroll .scroll-trigger')).forEach((section, index) => {
                const w = section;
                var x = w.scrollWidth * -1;
                var xEnd = 0;
                if($(section).closest('.pxl-horizontal-scroll').hasClass('revesal')){   
                    x = '100%';
                    xEnd = (w.scrollWidth - section.offsetWidth) * -1;
                } 
                gsap.fromTo(w, { x }, {
                    x: xEnd,
                    scrollTrigger: { 
                        trigger: section, 
                        scrub: 0.5 
                    }
                });
            });
        }
        showDemo();
    }
    // Make sure you run this code under Elementor.
    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_tabs.default', PXLTabsHandler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_tab_list.default', Pxl_Tablist_Animation_Handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_galleries.default', function( $scope ) {
            adsett_gallery_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_countdown.default', function( $scope ) {
            adsett_cound_down_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_accordion.default', function( $scope ) {
            adsett_accordion_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_video_gallery.default', function( $scope ) {
            adsett_video_gallery_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_service_grid.default', function( $scope ) {
            adsett_service_grid_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_image_before_after.default', function( $scope ) {
            adsett_image_before_after_handler($scope);
        } );  
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_progressbar.default', function( $scope ) {
            adsett_progressbar_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_counter.default', function( $scope ) {
            adsett_counter_handler($scope);
        } );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_title_effect.default', function( $scope ) {
            adsett_title_scroll_effect_handler($scope);
        } );
         
    } );
} )( jQuery );