;(function ($) {
    "use strict";
    var scroll_top;
    var window_height;
    var window_width;
    var scroll_status = '';
    var lastScrollTop = 0;
   
    $( document ).ready( function() {
        $('.tilt-hover').each(function () {
            $(this).tilt({
                reverse:        false,  // reverse the tilt direction
                max:            35,     // max tilt rotation (degrees)
                perspective:    1000,   // Transform perspective, the lower the more extreme the tilt gets.
                scale:          1.05,      // 2 = 200%, 1.5 = 150%, etc..
                speed:          1000,    // Speed of the enter/exit transition
                transition:     true,   // Set a transition on enter/exit.
                disableAxis:    null,   // What axis should be disabled. Can be X or Y.
                reset:          true,    // If the tilt effect has to be reset on exit.
                easing:         "cubic-bezier(.03,.98,.52,.99)",    // Easing on enter/exit.
            });
        });
        
        adsett_header_sticky();
        adsett_open_menu_toggle();

        adsett_mega_menu_style();
        adsett_panel_mobile_menu();
        adsett_panel_cart_toggle();
        adsett_panel_anchor_toggle();
        adsett_document_ready();
        adsett_document_click();
        adsett_scroll_to_top();
        adsett_footer_fixed();
        
        adsett_blog_post_gallery();
       
        adsett_shop_view_layout();
        adsett_wc_single_product_gallery();
        adsett_quantity_plus_minus();
        adsett_quantity_plus_minus_action();
        adsett_product_single_variations_att();
         
    });
     
    $(window).on('load', function () {
        if($(document).find('.pxl-loader').length > 0){
            $(".pxl-loader").fadeOut("slow");
        }
        
    });

    $(window).on('resize', function () {
        window_width = $(window).outerWidth();
        adsett_mega_menu_style();
        adsett_footer_fixed();
    });

    $(window).on('scroll', function () {
        scroll_top = $(window).scrollTop();
        window_height = $(window).height();
        window_width = $(window).width();
        if (scroll_top < lastScrollTop) {
            scroll_status = 'up';
        } else {
            scroll_status = 'down';
        }
        lastScrollTop = scroll_top;
 
        adsett_header_sticky();
        adsett_scroll_to_top();
    });
 
    jQuery( document ).on( 'updated_wc_div', function() {
        adsett_quantity_plus_minus();
    } );
    

    function adsett_open_menu_toggle(){
        'use strict';
        $('.main-menu-toggle').on('click', function (e) {
            e.preventDefault();
            e.stopPropagation();
            if( !$(this).hasClass('open')){
                $(this).closest('ul').find('.main-menu-toggle.open').toggleClass('open');
                $(this).closest('ul').find('.sub-menu.submenu-open').toggleClass('submenu-open').slideToggle();
            }
            $(this).toggleClass('open');  
            $(this).closest('.menu-item').find('> .sub-menu').toggleClass('submenu-open');
            $(this).closest('.menu-item').find('> .sub-menu').slideToggle(); 
        });

        //* Menu Dropdown
         
        $('.pxl-primary-menu li').each(function () {
            var $submenu = $(this).find('> ul.sub-menu');
            if ($submenu.length == 1) {
                $(this).hover(function () {
                    if ($submenu.offset().left + $submenu.width() > $(window).width()) {
                        $submenu.addClass('back');
                    } else if ($submenu.offset().left < 0) {
                        $submenu.addClass('back');
                    }
                }, function () {
                    $submenu.removeClass('back');
                });
            }
        });
        
        
    } 

    function adsett_mega_menu_style(){
        if($(document).find('.pxl-mega-menu').length > 0){
            if($(window).outerWidth() < 1200 ){
                $('.pxl-mega-menu').closest("li.pxl-megamenu").css('position', 'relative');    
            }else{
                $('.pxl-mega-menu').closest("li.pxl-megamenu").css('position', 'static');     
            }
        }
        if($(document).find('.mn-home-item.pxl-megamenu').length > 0){
            if($(window).outerWidth() >= 1200 ){
                $(document).find('.mn-home-item.pxl-megamenu').each(function() {
                    var offset_left = $(this).offset().left;
                    $(this).find('.sub-menu.pxl-mega-menu').css('left',(offset_left)*-1);
                    $(this).css('position', 'relative'); 
                });
            }
        }
        
    }
    /* Header Sticky */
    function adsett_header_sticky() {
        'use strict';
        if($(document).find('.pxl-header-sticky').length > 0 && window_width >= 1200){
            var header_height = $('.pxl-header-desktop').outerHeight();
            
            var offset_top_nimation = header_height + 150;
             
            if (scroll_top > offset_top_nimation) {
                $(document).find('.pxl-header-sticky').addClass('h-fixed');
            }else{
                $(document).find('.pxl-header-sticky').removeClass('h-fixed');
            }
        } 
        if($(document).find('.pxl-header-main-sticky').length > 0 && window_width >= 1200){
            var header_height = $('.pxl-header-desktop').outerHeight();
                
            if (scroll_top > header_height) {
                $(document).find('.pxl-header-main-sticky').addClass('h-fixed');
            }else{
                $(document).find('.pxl-header-main-sticky').removeClass('h-fixed');
            }
        } 
        if ( $(document).find('.pxl-header-mobile-sticky').length > 0 && window_width < 1200  ) {
            var offset_top = $('.pxl-header-mobile').outerHeight();
             
            if (scroll_top > offset_top) {
                $(document).find('.pxl-header-mobile-sticky').addClass('mh-fixed');
            }else{
                $(document).find('.pxl-header-mobile-sticky').removeClass('mh-fixed');
            }
        }
        if ( $(document).find('.pxl-header-mobile-main-sticky').length > 0 && window_width < 1200  ) {
            var offset_top = $('.pxl-header-mobile').outerHeight();
             
            if (scroll_top > offset_top + 1) {
                $(document).find('.pxl-header-mobile-main-sticky').addClass('mh-fixed');
            }else{
                $(document).find('.pxl-header-mobile-main-sticky').removeClass('mh-fixed');
            }
        }
       
    }

    function adsett_panel_mobile_menu(){
        'use strict';
        $(document).on('click','.btn-nav-mobile',function(e){
            e.preventDefault();
            e.stopPropagation();
            var target = $(this).attr('data-target');
            $(this).toggleClass('cliked');
            $(target).toggleClass('open');
            $('body').toggleClass('side-panel-open');
        });
        
        $('.pxl-mobile-menu .is-one-page').on('click', function(e) {
            $(document).trigger('click');
        });
    }
    function adsett_panel_cart_toggle(){
        'use strict';
        $(document).on('click','.pxl-cart-toggle',function(e){
            e.preventDefault();
            e.stopPropagation();
            var target = $(this).attr('data-target');
            $(this).toggleClass('cliked');
            $(target).toggleClass('open');
            $('body').toggleClass('side-panel-open');
        });
    }
    function adsett_panel_anchor_toggle(){
        'use strict';
        $(document).on('click','.pxl-anchor.side-panel',function(e){
            e.preventDefault();
            e.stopPropagation();
            var target = $(this).attr('data-target');
            $(this).toggleClass('cliked');
            $(target).toggleClass('open');
            $('body').toggleClass('side-panel-open');
            if($(target).find('.pxl-search-template').length > 0){
                setTimeout(function(){
                    $(target).find('.pxl-search-form input[name="s"]').focus();
                    $(target).find('.search-form input[name="s"]').focus();
                },1000);
            }
        });
        $(document).on('click','.custom-link.anchor',function(e){
            e.preventDefault();
            e.stopPropagation();
            var target = $(this).attr('data-target');
            $(this).toggleClass('cliked');
            $(target).toggleClass('anchor-target-open');
        });
    }

    function adsett_document_ready(){
        $('.pxl-mega-menu').find('.menu-item').each(function(index, el) {
            if($(el).hasClass('active')){
                $(el).parents('li.menu-item.pxl-megamenu').addClass('current-menu-ancestor current-menu-parent')
            }
        });
    }
    function adsett_document_click(){
        $(document).on('click',function (e) {
            var target = $(e.target);
            var check = '.btn-nav-mobile';
            
            if (!(target.is(check)) && target.closest('.pxl-hidden-template').length <= 0 && $('body').hasClass('side-panel-open')) { 
                $('.btn-nav-mobile').removeClass('cliked');
              
                $('.pxl-hidden-template').removeClass('open');
                $('body').removeClass('side-panel-open');
            }
        });
        $(document).on('click','.pxl-close',function(e){
            e.preventDefault();
            e.stopPropagation();
            $(this).closest('.pxl-hidden-template').toggleClass('open');
            $('.btn-nav-mobile').removeClass('cliked');
           
            $('body').toggleClass('side-panel-open');
        });
        
        $('.pxl-scroll-top').click(function(e) {
            e.preventDefault();
            e.stopPropagation();
            var _target = $(this).attr('data-target');
            $('html, body').stop().animate({ scrollTop: $(_target).offset().top }, 1000);   
        });
        
    }

    /* Scroll To Top */
    function adsett_scroll_to_top() {
        if (scroll_top < window_height) {
            $('.pxl-scroll-top').addClass('off').removeClass('on');
        }
        if (scroll_top > window_height) {
            $('.pxl-scroll-top').addClass('on').removeClass('off');
        }
        
    }
    function adsett_footer_fixed() {
        if($('.footer-fixed').length <= 0) return;
        setTimeout(function(){
            var h_footer = $('.pxl-footer-fixed').outerHeight() - 1;
            $('.footer-fixed .pxl-main').css('margin-bottom', h_footer + 'px');
        }, 600);
    }
    
    function adsett_blog_post_gallery(){
        if($('.post.format-gallery .post-gallery-slider').length <= 0) return;
        var swiper = new Swiper(".post-gallery-slider .pxl-swiper-container", {
            navigation: {
                nextEl: ".pxl-swiper-arrow-next",
                prevEl: ".pxl-swiper-arrow-prev",
            },
        });
    }
  
    function adsett_shop_view_layout(){
        
        $(document).on('click','.pxl-view-layout .view-icon a', function(e){
            e.preventDefault();
            if(!$(this).parent('li').hasClass('active')){
                $('.pxl-view-layout .view-icon').removeClass('active');
                $(this).parent('li').addClass('active');
                $(this).parents('.pxl-content-area').find('ul.products').removeAttr('class').addClass($(this).attr('data-cls'));
            }
        });
    }

    function adsett_wc_single_product_gallery(){
        'use strict';
        if(typeof $.flexslider != 'undefined'){
            $('.wc-gallery-sync').each(function() {
                var itemW      = parseInt($(this).attr('data-thumb-w')),
                    itemH      = parseInt($(this).attr('data-thumb-h')),
                    itemN      = parseInt($(this).attr('data-thumb-n')),
                    itemMargin = parseInt($(this).attr('data-thumb-margin')),
                    window_w = $(window).outerWidth(),
                    itemSpace  = itemH - itemW + itemMargin;
                var gallery_layout = window_w > 575 ? 'vertical' : 'horizontal';

                if($(this).hasClass('thumbnail-vertical')){
                    $(this).flexslider({
                        selector       : '.wc-gallery-sync-slides > .wc-gallery-sync-slide',
                        animation      : 'slide',
                        controlNav     : false,
                        directionNav   : true,
                        prevText       : '<span class="flex-prev-icon"></span>',
                        nextText       : '<span class="flex-next-icon"></span>',
                        asNavFor       : '.woocommerce-product-gallery',
                        direction      : gallery_layout,
                        slideshow      : false,
                        animationLoop  : false,
                        itemWidth      : itemW, // add thumb image height
                        itemMargin     : itemSpace, // need it to fix transform item
                        move           : 1,
                        start: function(slider){
                            var asNavFor     = slider.vars.asNavFor,
                                height       = $(asNavFor).height(),
                                height_thumb = $(asNavFor).find('.flex-viewport').height();
                            if(window_w > 575) {
                                slider.css({'max-height' : height_thumb, 'overflow': 'hidden'});
                                slider.find('> .flex-viewport > *').css({'height': height, 'width': ''});
                            } 
                        }
                    });
                }
                if($(this).hasClass('thumbnail-horizontal')){
                    $(this).flexslider({
                        selector       : '.wc-gallery-sync-slides > .wc-gallery-sync-slide',
                        animation      : 'slide',
                        controlNav     : false,
                        directionNav   : true,
                        prevText       : '<span class="flex-prev-icon"></span>',
                        nextText       : '<span class="flex-next-icon"></span>',
                        asNavFor       : '.woocommerce-product-gallery',
                        slideshow      : false,
                        animationLoop  : false, // Breaks photoswipe pagination if true.
                        itemWidth      : itemW,
                        itemMargin     : itemMargin,
                        start: function(slider){

                        }
                    });
                };
            });
        }
    }

    function adsett_quantity_plus_minus(){
        "use strict";
        $( ".quantity input" ).wrap( "<div class='pxl-quantity'></div>" );
        $('<span class="quantity-button quantity-down"></span>').insertBefore('.quantity input');
        $('<span class="quantity-button quantity-up"></span>').insertAfter('.quantity input');
        // contact form 7 input number
        $('<span class="pxl-input-number-spin"><span class="pxl-input-number-spin-inner pxl-input-number-spin-up"></span><span class="pxl-input-number-spin-inner pxl-input-number-spin-down"></span></span>').insertAfter('.wpcf7-form-control-wrap input[type="number"]');
    }
    function adsett_ajax_quantity_plus_minus(){
        "use strict";
        $('<span class="quantity-button quantity-down"></span>').insertBefore('.quantity input');
        $('<span class="quantity-button quantity-up"></span>').insertAfter('.quantity input');
    }
    function adsett_quantity_plus_minus_action(){
        "use strict";
        $(document).on('click','.quantity .quantity-button',function () {
            var $this = $(this),
                spinner = $this.closest('.quantity'),
                input = spinner.find('input[type="number"]'),
                step = input.attr('step'),
                min = input.attr('min'),
                max = input.attr('max'),value = parseInt(input.val());
            if(!value) value = 0;
            if(!step) step=1;
            step = parseInt(step);
            if (!min) min = 0;
            var type = $this.hasClass('quantity-up') ? 'up' : 'down' ;
            switch (type)
            {
                case 'up':
                    if(!(max && value >= max))
                        input.val(value+step).change();
                    break;
                case 'down':
                    if (value > min)
                        input.val(value-step).change();
                    break;
            }
            if(max && (parseInt(input.val()) > max))
                input.val(max).change();
            if(parseInt(input.val()) < min)
                input.val(min).change();
        });
        $(document).on('click','.pxl-input-number-spin-inner',function () {
            var $this = $(this),
                spinner = $this.parents('.wpcf7-form-control-wrap'),
                input = spinner.find('input[type="number"]'),
                step = input.attr('step'),
                min = input.attr('min'),
                max = input.attr('max'),value = parseInt(input.val());
            if(!value) value = 0;
            if(!step) step=1;
            step = parseInt(step);
            if (!min) min = 0;
            var type = $this.hasClass('pxl-input-number-spin-up') ? 'up' : 'down' ;
            switch (type)
            {
                case 'up':
                    if(!(max && value >= max))
                        input.val(value+step).change();
                    break;
                case 'down':
                    if (value > min)
                        input.val(value-step).change();
                    break;
            }
            if(max && (parseInt(input.val()) > max))
                input.val(max).change();
            if(parseInt(input.val()) < min)
                input.val(min).change();
        });
    }
    function adsett_product_single_variations_att(){
        $(document).on('mousedown', '.pro-variation-select', function (e) {
            e.preventDefault();
            var $this_var = $(this).closest('.variations'),
                this_closest = $(this).closest('.pxl-variation-att-terms'),
                target_hidden = $this_var.find('#'+this_closest.attr('data-id'));
            var $this = $(this);
            if (!$this.hasClass('custom-vari-enabled'))
                return;
            var target = $this.attr('data-value');
            if (!target)
                return;
            target_hidden.val(target).change();
            this_closest.find('li.pxl-vari-item').removeClass('active');
            $this.parent('li').addClass('active');
        });
    }
      

})(jQuery);

