<?php
/**
 * @package Adsett
 */
get_header(); ?>
<?php 
    $template_404 = (int)adsett()->get_theme_opt('template_404',0); 
    $img_default = get_template_directory_uri() . '/assets/images/404-number.png';
?>
<div class="container">
    <?php if ($template_404 <= 0 || !class_exists('Pxltheme_Core') || !is_callable( 'Elementor\Plugin::instance' )): ?>
        <main id="pxl-content-main" class="pxl-content-main">
            <div class="page-404-wrap relative d-flex align-items-center justify-content-center text-center">
                <div class="row page-404-content">
                    <div class="col-12">
                        <div class="page-404-inner relative">
                            <img src="<?php echo esc_url($img_default) ?>">
                            <h3 class="title"><?php echo esc_html__( 'Oops... It looks like you ‘re lost ! ', 'adsett' ) ?></h3>
                            <a class="pxl-btn outline-under draw" href="<?php echo esc_url(home_url('/')); ?>"><span class="draw-top-right"></span>
                            <span class="draw-bottom-left"></span><span class="btn-text"><?php echo esc_html__('back to home', 'adsett'); ?></span></a>
                        </div>
                    </div>
                </div>
            </div>
        </main>    
    <?php else: ?>
        <?php if( $template_404 > 0): ?>
            <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $template_404); ?>      
        <?php endif; ?>
    <?php endif; ?>
</div>
 
 
<?php get_footer();
